	PROCESSOR 16F887
	#include <P16F887.inc>
	__CONFIG	_CONFIG1, 020C4h
	__CONFIG	_CONFIG2, _WRT_OFF & _BOR21V
	CBLOCK 0x20
	TEMP_STATUS		;   STATUS    
	COUNT_LM ;       

	SLAVE        ;   (YYYYxxx0)
	TXBUF        ;  
	RXBUF        ;  
	COUNT        ;  
	ADDR		 ;  
	DATAI        ;     
	DATAO        ;     
	DATAI_1      ;     
	DATAO_1      ;     
	FLAG         ;    
	I2CDEV       ;  
	ERCODE       ;      
	TemperatureTimer1 ;    
	TemperatureTimer2 ;    

	WholeDegres		;   
	DecimalDegres	;   

	hundreds ;     
	tens_and_ones ;       

	TemperatureZnak ;  

	SendBait1 ; 1     LM7001
	SendBait2 ; 2     LM7001
	SendBait3 ; 3     LM7001

	Registr   ;    
	Registr2   ;    

	FmPcDrbezg ;     FM/PC  
	UartReg ;      Uart
	UartRegCom ;     Uart
	UartChar ;    Uart
	UartComRegistr ;  /   
	UartComRegistr2 ;  /   
	UartSendComType ;   : K -    , Y-   ,
	UartSendComValue ;   
	EncoderReg ;   

	AdcStatus ;   
	WheelKeyDrbezg ;     
	WheelKeySendCode;        
	ModeKeySendCode ;      MODE,      WheelKeySendCode
	EnVolumeOld	;     
	EnStationOld 	;      
	ModeTimer1 ;           Mode
	ACCTimer1 ;   4   
	ACCTimer2 ;   4   
	ACCV ;      
	dataL

	Uart0
	Uart1
	Uart2
	Uart3
	Uart4
	Uart5
	Uart6
	Uart7

	endc 

	SDA         equ    4   ; RA0 /  SDA
	SCL         equ    3   ; RA1   SCL
	DI          equ    7 ;    I2C
	D0          equ    6 ;   	I2C
	ERR1        equ    0 ; - 	

	W_Temp	equ 0x70		;   W    

	#DEFINE CeLm PORTB, 0 ;   LM7001
	#DEFINE DataLm PORTB, 1 ;   LM7001
	#DEFINE ClockLm PORTB, 2 ;   LM7001

	#DEFINE SaveVolume PORTB, 3 ;     1    

	#DEFINE EnStationUp PORTB, 5 ;    A( )
	#DEFINE EnStationDown PORTB, 4 ;   B ( )

	#DEFINE EnVolueUp PORTB, 7 ;   A ( )
	#DEFINE EnVolueDown PORTB, 6 ;   B ( )

	#DEFINE Mute PORTD, 0 ;  Mute
	#DEFINE Ampiler PORTD, 1 ;  

	#DEFINE KeyStatus_NextKeyDown Registr, 0 ;    1    ,    
	#DEFINE KeyStatus_PrevKeyDown Registr, 1 ;    1    ,    
	#DEFINE KeyStatus_ModeKeyDown Registr, 2 ;    1  Mode ,          		
	#DEFINE StartTemperature1 Registr, 3 ;    1 -       1 	
	#DEFINE StartTemperature2 Registr, 4 ;    1 -       2 	
	#DEFINE SendAccV Registr, 5 ;    1     ACC
	#DEFINE SelTemperatureDatchik Registr, 6 ;    0  1   - 1   
	#DEFINE WriteFrequencyTuner Registr, 7 ;    1        

	;#DEFINE SaveVolumeSet Registr2, 0 ;    1          
	
	#DEFINE	KeyStatus_Mute Registr2, 2 ;          FM\PC

;	#DEFINE WriteMemoryTuner UartComRegistr, 0 ;    1           
	#DEFINE SendComUart UartComRegistr, 1 ;    1     ,  0       
	;#DEFINE Chr_C_SendCom UartComRegistr, 2 ;   1   "",     
	;#DEFINE Chr_o_SendCom UartComRegistr, 3 ;   1   "0",     
	;#DEFINE Chr_m_SendCom UartComRegistr, 4 ;   1   "m",     
	;#DEFINE TypeCom_SendCom UartComRegistr, 5 ;   1     (K -    , Y-   , -   )
	;#DEFINE Com_SendCom UartComRegistr, 6 ;   1     ,       ()
	;#DEFINE SendComMemoryUart UartComRegistr, 7 ;    1      ,  0       

;	#DEFINE Bait1_SendCom UartComRegistr2, 0  ;   1   1    ,      ()
;	#DEFINE Bait2_SendCom UartComRegistr2, 1  ;   1   2    ,      ()
;	#DEFINE Bait3_SendCom UartComRegistr2, 2  ;   1   3    ,      ()

	#DEFINE WhelKeyDown AdcStatus, 0 ;   1     
	;#DEFINE VolumePlusKeyDown AdcStatus, 1 ;    1     
	;#DEFINE VolumeMinusKeyDown AdcStatus, 2 ;    1     
;	#DEFINE ModeKeyDown AdcStatus, 3 ;    1    
	#DEFINE ModeShotKeyDown AdcStatus, 4 ;    1     
	#DEFINE ModeLongKeyDown AdcStatus, 5 ;    1     
	#DEFINE PrevKeyDown AdcStatus, 6 ;    1     
	#DEFINE NextKeyDown AdcStatus, 7 ;    1     

	#DEFINE TempValumeClockwise EncoderReg, 0 ;    1      ,  
	#DEFINE ValumeClockwise EncoderReg, 1 ;    1      ,     
	#DEFINE TempValumeounterlockwise EncoderReg, 2 ;    1      ,  
	#DEFINE Valumeounterlockwise EncoderReg, 3 ;    1      ,     

	#DEFINE TempStationClockwise EncoderReg, 4 ;    1       ,  
	#DEFINE StationClockwise EncoderReg, 5 ;    1       ,     
	#DEFINE TempStationounterlockwise EncoderReg, 6 ;    1       ,  
	#DEFINE Stationounterlockwise EncoderReg, 7 ;    1       ,     



	org 0x000
	goto Start
	ORG 0x004 ; 
	goto Interupt

;**************************************************
; 
;**************************************************
Interupt:
	
	movwf W_Temp 
	SWAPF STATUS,w
	clrf STATUS
	MOVWF TEMP_STATUS

	btfsc PIR1,RCIF         
	goto IntUsartIn 	;     USart
	btfsc PIR1,ADIF         
	goto IntADC 	;    
	btfsc INTCON,RBIF
	goto IntEncoder ;      B
	btfsc INTCON,T0IF
	goto IntTMR0 ;     TMR0
	goto ExitInt

;**************************************************
;    USART
;**************************************************
IntUsartIn:
	bcf PIR1,RCIF
	movf RCREG,W
	movwf UartChar

	movfw UartReg
	addwf PCL,f 
	goto IntUsartInChar1 ;      "C"
	goto IntUsartInChar2 ;      "o"
	goto IntUsartInChar3 ;      "m"
	goto IntUsartInComType ;  4     T-   , -      , -   , R   
	nop
	goto IntUsartInComAmpiler ;      
	nop
	goto IntUsartInComTuner ;   () 

IntUsartInComTuner:
	movfw UartRegCom
	addwf PCL,f 
	goto IntUsartInComTuner_Bayt1
	goto IntUsartInComTuner_Bayt2
	goto IntUsartInComTuner_Bayt3

IntUsartInComAmpiler: ;      
	movf UartChar,w
	sublw .49 ; 1
	btfss STATUS,Z
	goto InComAmpilerOff
	goto InComAmpilerOn

InComAmpilerOn:
	bsf Ampiler
	goto ExitInt

InComAmpilerOff
	bcf Ampiler
	goto ExitInt

IntUsartInChar1: ; 1   "C"
	movf UartChar,w
	sublw .67 ; C
	btfss STATUS,Z
	goto IntUsartChar1False
	goto IntUsartChar1True
IntUsartChar1False:
	goto ExitInt
IntUsartChar1True:
	movlw .1
	movwf UartReg
	goto ExitInt
IntUsartInChar2: ; 2   "o"
	movf UartChar,w
	sublw .111 ; o
	btfss STATUS,Z
	goto IntUsartChar2False
	goto IntUsartChar2True
IntUsartChar2False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar2True:
	movlw .2
	movwf UartReg
	goto ExitInt
IntUsartInChar3: ; 3   "m"
	movf UartChar,w
	sublw .109 ; m
	btfss STATUS,Z
	goto IntUsartChar3False
	goto IntUsartChar3True
IntUsartChar3False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar3True:
	movlw .3
	movwf UartReg
	goto ExitInt
IntUsartInComType: ;  4   T-   , -      , -   
	movf UartChar,w
	sublw .77 ; M
	btfss STATUS,Z
	goto IntUsartInComTypeM_False
	goto IntUsartInComTypeM_True
IntUsartInComTypeM_True:
	movlw .4
	movwf UartReg
	clrf UartRegCom
	goto ExitInt
IntUsartInComTypeM_False:
	movf UartChar,w
	sublw .65 ; A
	btfss STATUS,Z
	goto IntUsartInComTypeA_False
	goto IntUsartInComTypeA_True
IntUsartInComTypeA_True:
	movlw .5
	movwf UartReg
	goto ExitInt
IntUsartInComTypeA_False:

	movf UartChar,w
	sublw .84 ; T
	btfss STATUS,Z
	goto IntUsartInComTypeT_False
	goto IntUsartInComTypeT_True
IntUsartInComTypeT_True:
	movlw .7
	movwf UartReg
	clrf UartRegCom
	goto ExitInt
IntUsartInComTypeT_False:
	movf UartChar,w
	sublw .82 ; R
	btfss STATUS,Z
	goto IntUsartInComTypeR_False
	goto IntUsartInComTypeR_True
IntUsartInComTypeR_True:
	movlw .6
	movwf UartReg
	goto ExitInt
IntUsartInComTypeR_False:

	clrf UartReg
	goto IntUsartInChar1



IntUsartInComTuner_Bayt1: ;  1    ,    3-    3   
	movf UartChar,w
	movwf SendBait1
	movlw .1
	movwf UartRegCom
	goto ExitInt
IntUsartInComTuner_Bayt2: ;  2    ,    3-    3   
	movf UartChar,w
	movwf SendBait2
	movlw .2
	movwf UartRegCom
	goto ExitInt
IntUsartInComTuner_Bayt3: ;  3    ,    3-    3   
	movf UartChar,w
	movwf SendBait3
	clrf UartReg
	bsf WriteFrequencyTuner
	goto ExitInt


;**************************************************
;    
;**************************************************
IntADC: 
	bcf PIR1,ADIF
	btfss ADCON0,CHS0
	goto IntADCKey
;**************************************************
;    
;**************************************************
	bcf ADCON0,CHS0
	decfsz ACCTimer1
	goto ExitIntADC
	movlw .250
	movwf ACCTimer1
	decfsz ACCTimer2
	goto ExitIntADC
	movlw .5
	movwf ACCTimer2
	movf ADRESH, w
	btfsc STATUS,Z
	addlw .1
	movwf ACCV
	bsf SendAccV
	goto ExitIntADC
;**************************************************
;    
;**************************************************
IntADCKey:
	btfss WhelKeyDown
	goto $+3
	decfsz WheelKeyDrbezg
	goto ExitIntADC

	bsf ADCON0,CHS0
	movf ADRESH, w
	addlw .96 ;  255-(159)
	addlw .13 ;    (-+1)	159-147+1 
	btfsc STATUS, C
	Goto VolumeDown ;   

	movf ADRESH, w
	addlw .122 ;  255-(133)
	addlw .13 ;    (-+1)	133-121+1 
	btfsc STATUS, C
	Goto VolumeUp ;   

	movf ADRESH, w
	addlw .173 ;  255-(82)
	addlw .13 ;    (-+1)	82-70+1 
	btfsc STATUS, C
	Goto Mode ;  Mode

	movf ADRESH, w
	addlw .198 ;  255-(57)
	addlw .13 ;    (-+1)	57-45+1 
	btfsc STATUS, C
	Goto PrevTrack ;   

	movf ADRESH, w
	addlw .224 ;  255-(31)
	addlw .13 ;    (-+1)	31-19+1 
	btfsc STATUS, C
	Goto NextTrack ;   

	;     
	bcf WhelKeyDown
	bcf KeyStatus_NextKeyDown
	bcf KeyStatus_PrevKeyDown
	bcf KeyStatus_ModeKeyDown
	movf ModeKeySendCode,w
	btfsc STATUS,Z
	goto ExitIntADC
	clrf ModeKeySendCode
	movwf WheelKeySendCode
	goto ExitIntADC
VolumeDown:
	btfsc WhelKeyDown
	goto $+5
	movlw .105
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf Valumeounterlockwise
	goto ExitIntADC
VolumeUp:
	btfsc WhelKeyDown
	goto $+5
	movlw .105
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf ValumeClockwise
	goto ExitIntADC
Mode:
	btfss KeyStatus_ModeKeyDown
	goto Mode1
	decfsz ModeTimer1
	goto ExitIntADC
	movlw .4
	movwf ModeKeySendCode
	movlw .1
	movwf ModeTimer1
	goto ExitIntADC
Mode1:
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
;	bsf ModeKeyDown	
	movlw .3
	movwf ModeKeySendCode
	movlw .7
	movwf ModeTimer1
	bsf KeyStatus_ModeKeyDown
	goto ExitIntADC
PrevTrack:
	btfss KeyStatus_PrevKeyDown
	goto PrevTrack1
	decfsz ModeTimer1
	goto ExitIntADC
	movlw .135
	movwf ModeKeySendCode
	movlw .1
	movwf ModeTimer1
	goto ExitIntADC
PrevTrack1:
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf PrevKeyDown
	movlw .1
	movwf ModeKeySendCode
	movlw .7
	movwf ModeTimer1
	bsf KeyStatus_PrevKeyDown
	goto ExitIntADC
NextTrack:
	btfss KeyStatus_NextKeyDown
	goto NextTrack1
	decfsz ModeTimer1
	goto ExitIntADC
	movlw .136
	movwf ModeKeySendCode
	movlw .1
	movwf ModeTimer1
	goto ExitIntADC
NextTrack1:
	btfsc WhelKeyDown
	goto $+5
	movlw .5
	movwf WheelKeyDrbezg
	bsf WhelKeyDown
	goto ExitIntADC
	bsf NextKeyDown
	movlw .2
	movwf ModeKeySendCode
	movlw .7
	movwf ModeTimer1
	bsf KeyStatus_NextKeyDown
	goto ExitIntADC

ExitIntADC:

 	goto ExitInt

;**************************************************
;     TMR0
;**************************************************
IntTMR0:
	bcf INTCON,T0IF
	bsf ADCON0,GO ;    
	decfsz  TemperatureTimer1
	goto ExitInt
	movlw .200
	movwf TemperatureTimer1
	decfsz  TemperatureTimer2
	goto ExitInt
	movlw .5
	movwf TemperatureTimer2
	btfsc SelTemperatureDatchik
	goto $+4
	bsf StartTemperature1
	bsf SelTemperatureDatchik
	goto $+3
	bsf StartTemperature2
	bcf SelTemperatureDatchik

	goto ExitInt
;**************************************************
;      PORTB
;**************************************************
IntEncoder:
	movf PORTB,w
	bcf INTCON,RBIF
	andlw b'11000000'
;**************************************************
;     Volume  PORTB
;**************************************************
	xorwf EnVolumeOld, w
	bz IntEncoderStation
	xorwf   EnVolumeOld,W        ; restore WREG
	movwf   EnVolumeOld
IntEncoderValue:
	btfsc EnVolueUp
	goto EnVolue1
	btfsc EnVolueDown
	goto EnVolue2
	bcf TempValumeClockwise ;  
	bcf TempValumeounterlockwise ;  
	goto IntEncoderStation

EnVolue1:
	btfsc EnVolueDown
	goto EnVolue1_1
	goto EnVolue1_2
EnVolue1_1: ;    1:1
	goto IntEncoderStation
EnVolue1_2:
	btfss TempValumeClockwise
	goto EnVolue1_2_1
	goto EnVolue1_2_2
EnVolue1_2_1:
	btfsc TempValumeounterlockwise
	goto IntEncoderStation
	bsf TempValumeounterlockwise ; 
	bsf Valumeounterlockwise
	goto ExitInt
EnVolue1_2_2:
	bcf TempValumeClockwise ;  
	goto ExitInt
EnVolue2:
	btfsc EnVolueDown
	goto EnVolue2_1
	goto EnVolue2_2
EnVolue2_1:
	btfss TempValumeounterlockwise
	goto EnVolue2_2_1
	goto EnVolue2_2_2
EnVolue2_2_1:
	btfsc TempValumeClockwise
	goto IntEncoderStation
	bsf TempValumeClockwise  ; 
	bsf ValumeClockwise
	goto ExitInt
EnVolue2_2_2:
	bcf TempValumeounterlockwise ;  
	goto ExitInt
EnVolue2_2: ;    0:0
	goto IntEncoderStation

;**************************************************
;        PORTB
;**************************************************
IntEncoderStation:
	movf PORTB,w
	andlw b'00110000'
	xorwf 	EnStationOld, w
	bz ExitInt
	xorwf EnStationOld,W        ; restore WREG
	movwf EnStationOld

	btfsc EnStationUp
	goto EnStation1
	btfsc EnStationDown
	goto EnStation2
	goto ExitInt
EnStation1:
	btfsc EnStationDown
	goto EnStation1_1
	goto EnStation1_2
EnStation1_1: ;    1:1
	goto ExitInt
EnStation1_2:
	btfss TempStationClockwise
	goto EnStation1_2_1
	goto EnStation1_2_2
EnStation1_2_1:
	bsf TempStationounterlockwise ; 
	bsf Stationounterlockwise
	goto ExitInt
EnStation1_2_2:
	bcf TempStationClockwise ;  
	goto ExitInt
EnStation2:
	btfsc EnStationDown
	goto EnStation2_1
	goto EnStation2_2
EnStation2_1:
	btfss TempStationounterlockwise
	goto EnStation2_2_1
	goto EnStation2_2_2
EnStation2_2_1:
	bsf TempStationClockwise  ; 
	bsf StationClockwise
	goto ExitInt
EnStation2_2_2:
	bcf TempStationounterlockwise ;  
	goto ExitInt
EnStation2_2: ;    0:0
	goto ExitInt

ExitInt:
	MOVF W_Temp,w
	SWAPF TEMP_STATUS,w
	MOVWF STATUS
	bsf INTCON,GIE
	RETURN ;   

Start:
;**************************************************
;  
;**************************************************
	bcf STATUS,RP1
	bcf STATUS, RP0
	clrf PORTA
	clrf PORTB
	clrf PORTD
	bsf       STATUS,RP0
  	bsf       STATUS,RP1          ; select Register Bank 3
	movlw     0xFF                ; we want all Port A pins Analog
	movwf     ANSEL
	movlw     0x00
	movwf     ANSELH              ; PortB pins are digitial (important as RB0 is switch)
	bcf       STATUS,RP1

	movlw b'11110000'
	movwf IOCB ;   B     
	movlw b'00010011' ;  
	movwf TRISA
	movlw b'11111000' ;  
	movwf TRISB
	MOVLW b'10011000' 
	MOVWF TRISC
	MOVLW b'11000001' 
	MOVWF TRISD
	MOVLW b'00000010' 
	MOVWF TRISE
	MOVLW b'01000000'     
	MOVWF OPTION_REG
	MOVLW b'11110000'     
	MOVWF WPUB

	bcf STATUS, RP0


;**************************************************
;  UART
;**************************************************
	bsf STATUS,RP0
	banksel BAUDCTL
	bcf  BAUDCTL,SCKP
	bcf STATUS,RP1			
	movlw 0x0C              ; 0x19=9600 bps (0x0C=19200 bps)
	movwf SPBRG
	movlw b'00100100'       ; brgh = high (2)
	movwf TXSTA         
	bcf STATUS,RP0          ; RAM PAGE 0
	bcf STATUS,RP1
	movlw b'10010000'       ; enable Async Reception
	movwf RCSTA
        
;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'01101000' ;      , PORTB(RB4-RB7),TMR0   
	movwf INTCON
	movlw b'01100000'  ;     USART
	movwf PIE1
	bcf STATUS, RP0

;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'00000100' ;   RA0, RA1, RA3   
	movwf ADCON1
	bcf STATUS, RP0
	movlw b'10000001'
	movwf ADCON0 ;   Fosc/32,   
	;bsf ADCON0,GO ;    

;**************************************************
;    
;**************************************************
	movlw .250
	movwf ACCTimer1
	movlw .5
	movwf ACCTimer2
	clrf Registr
	clrf Registr2
	clrf UartReg
	clrf UartRegCom
	clrf dataL
	movlw .200
	movwf TemperatureTimer1
	movlw .5
	movwf TemperatureTimer2
settle 
	decfsz dataL,F
	goto settle
	clrf dataL
;**************************************************
;  
;**************************************************
	movlw 0x90		
	movwf SLAVE ;   
	movlw 0xEE	;  
	movwf ADDR 
	call WRCOM

	movlw 0x92		
	movwf SLAVE ;   
	movlw 0xEE	;  
	movwf ADDR 
	call WRCOM

	call message
	bsf INTCON,GIE		;   

	
Cycle:
;**************************************************
;  
;**************************************************

;**************************************************
;       
;**************************************************
	btfss WriteFrequencyTuner
	goto $+3
	bcf WriteFrequencyTuner
	call SendLM

;**************************************************
;      
;**************************************************
	btfsc SendComUart
	goto SendComNoEnd ;  
;**************************************************
;    Mute (+   )
;**************************************************
	MOVLW .10 ;    
	BTFSS KeyStatus_Mute ;    ,   
	goto Mute_Prtvios
	decfsz FmPcDrbezg
	goto Mute_Next
	MOVLW .1 ;    
Mute_Prtvios:
	BTFSS Mute 	;     Mute
	goto Mute_KeyDown ;
	goto Mute_KeyUp ; 
Mute_KeyDown:
	MOVWF FmPcDrbezg ;   
	BTFSC KeyStatus_Mute ;          
	goto Mute_Next 
	bsf KeyStatus_Mute
	movlw .24
	movwf WheelKeySendCode ;     pc
	goto Mute_Next 
Mute_KeyUp:
	bcf KeyStatus_Mute
Mute_Next:

;**************************************************
;      ,     
;**************************************************
	movf WheelKeySendCode,f
	btfsc STATUS,Z
	goto StationounterlockwiseCheck
	call InitSendKeyCode
;**************************************************
;       
;**************************************************
StationounterlockwiseCheck: 
	btfss Stationounterlockwise
	goto StationlockwiseCheck
StationounterlockwiseSendPC:
	movlw .22
	movwf WheelKeySendCode
	bcf Stationounterlockwise
;**************************************************
;       
;**************************************************
StationlockwiseCheck: 
	btfss StationClockwise
	goto ValumeounterlockwiseCheck
StationlockwiseSendPC:
	movlw .23
	movwf WheelKeySendCode
	bcf StationClockwise
;**************************************************
;       
;**************************************************
ValumeounterlockwiseCheck: 
	btfss Valumeounterlockwise
	goto ValumeClockwiseCheck
	movlw .20
	movwf WheelKeySendCode;    pc
	bcf Valumeounterlockwise
;**************************************************
;       
;**************************************************
ValumeClockwiseCheck: 
	btfss ValumeClockwise
	goto TemperatureCheck1
	movlw .21
	movwf WheelKeySendCode;    pc
	bcf ValumeClockwise
	goto Exit
;**************************************************
;      c  1
;**************************************************
TemperatureCheck1:
	btfss StartTemperature1
	goto TemperatureCheck2
	movlw 0x90		
	movwf SLAVE ;   
	movlw 0xAA	
	movwf ADDR 
	call RDBYTEN
	movf DATAI,w
	MOVWF WholeDegres
	movf DATAI_1,w
	MOVWF DecimalDegres
	btfss WholeDegres,7
	Goto Temperature1CheckPlus
Temperature1CheckMinus:
	movlw '-'
	movwf 	TemperatureZnak
	movfw WholeDegres
	sublw .255
	movwf WholeDegres
	incf WholeDegres
	goto $+3
Temperature1CheckPlus:
	movlw '+'
	movwf 	TemperatureZnak
	incf WholeDegres
	incf DecimalDegres
	bcf StartTemperature1
	call InitSendTemperature1
	goto Exit
;**************************************************
;      c  2
;**************************************************
TemperatureCheck2:
	btfss StartTemperature2
	goto AccCheck
	movlw 0x92		
	movwf SLAVE ;   
	movlw 0xAA	
	movwf ADDR 
	call RDBYTEN
	movf DATAI,w
	MOVWF WholeDegres
	movf DATAI_1,w
	MOVWF DecimalDegres
	btfss WholeDegres,7
	Goto Temperature2CheckPlus
Temperature2CheckMinus:
	movlw '-'
	movwf 	TemperatureZnak
	movfw WholeDegres
	sublw .255
	movwf WholeDegres
	incf WholeDegres
	goto $+3
Temperature2CheckPlus:
	movlw '+'
	movwf 	TemperatureZnak
	incf WholeDegres
	incf DecimalDegres
	bcf StartTemperature2
	call InitSendTemperature2
	goto Exit
;**************************************************
;         
;**************************************************
AccCheck:
	btfss SendAccV
	goto Exit
	bcf SendAccV
	call InitSendAccV
	goto Exit
;**************************************************
;    PC  
;**************************************************
SendComNoEnd:
	call send
	goto Exit
Exit:
;**************************************************
;   
;**************************************************
	goto Cycle



;**************************************************
;     LM7001 
;**************************************************
SendLM:
	;bcf INTCON,GIE
	bsf CeLm
	movlw .8
	movwf COUNT_LM
SendLmBait1:
	bcf DataLm
	btfsc SendBait1,7
	bsf DataLm
	call SendClockLm
	rlf SendBait1,f
	decfsz COUNT_LM,f
	goto SendLmBait1
	movlw .8
	movwf COUNT_LM
SendLmBait2:
	bcf DataLm
	btfsc SendBait2,7
	bsf DataLm
	call SendClockLm
	rlf SendBait2,f
	decfsz COUNT_LM,f
	goto SendLmBait2
	movlw .8
	movwf COUNT_LM
SendLmBait3:
	bcf DataLm
	btfsc SendBait3,7
	bsf DataLm
	call SendClockLm
	rlf SendBait3,f
	decfsz COUNT_LM,f
	goto SendLmBait3
	bcf DataLm
	bcf CeLm
	;bsf INTCON,GIE
	retlw 0

;**************************************************
;        LM7001 
;**************************************************
SendClockLm:
	bsf ClockLm
	nop
	nop
	nop
	bcf ClockLm
	return

;**************************************************
;       
;**************************************************
InitSendAccV:  
	bsf SendComUart 
	movlw 'C'
	movwf 	Uart0
	movlw 'o'
	movwf 	Uart1
	movlw 'm'
	movwf 	Uart2
	movlw 'U'
	movwf 	Uart3
	movf  ACCV,w
	movwf 	Uart4
	clrf	Uart5
	clrf	Uart6
	clrf	Uart7
	return

;**************************************************
;        
;**************************************************
InitSendKeyCode:  
	bsf SendComUart 
	movlw 'C'
	movwf 	Uart0
	movlw 'o'
	movwf 	Uart1
	movlw 'm'
	movwf 	Uart2
	movlw 'K'
	movwf 	Uart3
	movf  WheelKeySendCode,w
	movwf 	Uart4
	clrf	Uart5
	clrf	Uart6
	clrf	Uart7
	clrf WheelKeySendCode
	return

;**************************************************
;       N1 
;**************************************************
InitSendTemperature1:
	bsf SendComUart 
	movlw 'C'
	movwf 	Uart0
	movlw 'o'
	movwf 	Uart1
	movlw 'm'
	movwf 	Uart2
	movlw 'T'
	movwf 	Uart3
	movf  TemperatureZnak,w
	movwf 	Uart4
	movf  WholeDegres,w
	movwf 	Uart5
	movf  DecimalDegres,w
	movwf 	Uart6
	clrf	Uart7
	return

;**************************************************
;       N2 
;**************************************************
InitSendTemperature2:
	bsf SendComUart 
	movlw 'C'
	movwf 	Uart0
	movlw 'o'
	movwf 	Uart1
	movlw 'm'
	movwf 	Uart2
	movlw 'Y'
	movwf 	Uart3
	movf  TemperatureZnak,w
	movwf 	Uart4
	movf  WholeDegres,w
	movwf 	Uart5
	movf  DecimalDegres,w
	movwf 	Uart6
	clrf	Uart7
	return

;**************************************************
;    
;**************************************************
send:
	bsf STATUS,RP0 ;  1
	btfss TXSTA,TRMT ;      UArt
	goto SendNoEnd ;   
	bcf STATUS,RP0 ;  0
	movf Uart0,w ;      
	btfss STATUS,Z
	goto $+3 ;  
	bcf	SendComUart ;  ,   
	goto SendNoEnd ; 
	movf Uart0,w
	movwf TXREG
	movf Uart1,w
	movwf Uart0
	movf Uart2,w
	movwf Uart1
	movf Uart3,w
	movwf Uart2
	movf Uart4,w
	movwf Uart3
	movf Uart5,w
	movwf Uart4
	movf Uart6,w
	movwf Uart5
	movf Uart7,w
	movwf Uart6
	clrf Uart7
SendNoEnd:
	bcf STATUS,RP0 ;  0
	return



		
;***************************************************
;       I2C
;***************************************************
WRBYTE:
	movf SLAVE,w ;   
	movwf TXBUF ;   
	call BSTART ;   START
	call TX ;   
	movf ADDR,w ;   
	movwf TXBUF ;   
	call TX ;   
	movf DATAO,w ;  
	movwf TXBUF ;   
	call TX ;  
	call BSTOP ;   STOP
	return
;***************************************************
;     I2C
;***************************************************
WRCOM:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTOP
	return
;***************************************************
;       I2C
;***************************************************
WRBYTEN:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	movf DATAO,w
	movwf TXBUF
	call TX
	movf DATAO_1,w
	movwf TXBUF
	call TX
	call BSTOP
	return
;***************************************************
;      I2C
;***************************************************
RDBYTE:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTART
	movf SLAVE,w
	movwf TXBUF
	bsf TXBUF,0
	call TX
	call RX
	call BSTOP
	movf RXBUF,w
	movwf DATAI
	return
;***************************************************
;       I2C
;***************************************************
RDBYTEN
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTART
	movf SLAVE,w
	movwf TXBUF
	bsf TXBUF,0
	call TX
	call RX0
	movf RXBUF,w
	movwf DATAI
	call RX
	movf RXBUF,w
	movwf DATAI_1
	call BSTOP
	return
;***************************************************
;   
;***************************************************
BSTART:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bcf	TRISC,SDA
	bsf	TRISC,SCL
	bcf	STATUS,RP0
	bsf PORTC,SDA
	movlw .1
	btfss PORTC,SCL
	call ERR
	BCF PORTC,SDA
	nop
	nop
	nop
	bcf PORTC,SCL
	retlw 0
;**************************************************
;   
;**************************************************
BSTOP:
	bcf PORTC,SDA
	bcf       STATUS,RP1
	bsf       STATUS,RP0
	bcf	TRISC,SDA
	bsf	TRISC,SCL
	bcf	STATUS,RP0
	nop
	nop
	nop
	nop
	nop
	bsf STATUS,RP0
	bsf	TRISC,SDA
	bcf	STATUS,RP0
	movlw .1
	btfss PORTC,SCL
	call ERR
	movlw .4
	btfss PORTC,SDA
	call ERR
	retlw 0
;**************************************************
;      I2C
;**************************************************
BITIN:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bsf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	bcf I2CDEV,DI
	movlw .1
	btfsc PORTC,SCL
	goto BIT1
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
BIT1:
	bcf PORTC,SDA
	bsf STATUS,RP0
	bsf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	nop
	nop
	nop
	nop
	nop
	btfsc PORTC,SDA
	bsf I2CDEV,DI
	nop
	nop
	bcf	PORTC,SCL
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	retlw 0
;************************************************
;      I2C
;************************************************
BITOUT:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	btfss I2CDEV,D0
	goto BIT0
	bsf PORTC,SDA
	movlw .2
	btfsc PORTC,SDA
	goto CLK1
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
	goto CLK1
BIT0:
	bsf STATUS,RP0
	bcf TRISC,SDA
	bcf	STATUS,RP0
	bcf PORTC,SDA
	nop
	nop
	nop
	nop
	nop
CLK1:
	bsf STATUS,RP0
	bsf TRISC,SCL
	bcf	STATUS,RP0
	movlw .1
	btfsc PORTC,SCL
	goto BIT2
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
BIT2:
	nop
	nop
	nop
	bcf	PORTC,SCL
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf STATUS,RP0
	retlw 0
;**************************************************
;  8-    I2C
;**************************************************
RX:
	movlw .8
	movwf COUNT
	clrf RXBUF
RXLP:
	rlf RXBUF,f
	skpc
	bcf RXBUF,0
	skpnc
	bsf RXBUF,0
	call BITIN
	btfsc I2CDEV,DI
	bsf RXBUF,0
	decfsz COUNT,f
	goto RXLP
	bsf I2CDEV,D0
	call BITOUT
	retlw 0
;**************************************************
;  8-    I2C
;**************************************************
RX0:
	movlw .8
	movwf COUNT
	clrf RXBUF
RXLP0:
	rlf RXBUF,f
	skpc
	bcf RXBUF,0
	skpnc
	bsf RXBUF,0
	call BITIN
	btfsc I2CDEV,DI
	bsf RXBUF,0
	decfsz COUNT,f
	goto RXLP0
	bcf I2CDEV,D0
	call BITOUT
	retlw 0
;**************************************************
;     I2C 
;**************************************************
TX:
	movlw .8
	movwf COUNT
TXLP:
	bcf I2CDEV,D0
	btfsc TXBUF,7
	bsf I2CDEV,D0
	call BITOUT
	rlf TXBUF,f
	skpc
	bcf TXBUF,0
	skpnc
	bsf TXBUF,0
	decfsz COUNT,f
	goto TXLP
	call BIT1
	movlw .3
	btfsc I2CDEV,DI
	call ERR
	retlw 0
;***********************************************
;      I2C
;***********************************************
ERR:
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
	retlw 0

;***********************************************
;     
;***********************************************	
binary_to_bcd:
        CLRF    hundreds
        SWAPF   WholeDegres, W      ; swap the nibbles
        ADDWF   WholeDegres, W      ; so we can add the upper to the lower
        ANDLW   B'00001111' ; lose the upper nibble (W is in BCD from now on)
        SKPNDC              ; if we carried a one (upper + lower > 16)
         ADDLW  0x16        ; add 16 (the place value) (1s + 16 * 10s)
        SKPNDC              ; did that cause a carry from the 1's place?
         ADDLW  0x06        ; if so, add the missing 6 (carry is only worth 10)
        ADDLW   0x06        ; fix max digit value by adding 6
        SKPDC               ; if was greater than 9, DC will be set
         ADDLW  -0x06       ; if if it wasn't, get rid of that extra 6
        
        BTFSC   WholeDegres,4       ; 16's place
         ADDLW  0x16 - 1 + 0x6  ; add 16 - 1 and check for digit carry
        SKPDC
         ADDLW  -0x06       ; if nothing carried, get rid of that 6
        
        BTFSC   WholeDegres, 5      ; 32nd's place
         ADDLW  0x30        ; add 32 - 2
        
        BTFSC   WholeDegres, 6      ; 64th's place
         ADDLW  0x60        ; add 64 - 4
        
        BTFSC   WholeDegres, 7      ; 128th's place
         ADDLW  0x20        ; add 128 - 8 % 100
        
        ADDLW   0x60        ; has the 10's place overflowed?
        RLF     hundreds, F ; pop carry in hundreds' LSB
        BTFSS   hundreds, 0 ; if it hasn't
         ADDLW  -0x60       ; get rid of that extra 60
        
        MOVWF   tens_and_ones   ; save result
        BTFSC   WholeDegres,7       ; remeber adding 28 - 8 for 128?
         INCF   hundreds, F ; add the missing 100 if bit 7 is set
        
        RETURN              ; all done!
		


send1    movwf TXREG             ; send data in W 

TransWt bsf STATUS,RP0		; RAM PAGE 1
WtHere  btfss TXSTA,TRMT        ; (1) transmission is complete if hi
        goto WtHere

        bcf STATUS,RP0          ; RAM PAGE 0
        return
;
; -------
; MESSAGE
; -------
;
message 
	movlw 	'1'		
	call	send1
	movlw 	'6'
	call	send1
	movlw 	'F'
	call	send1
	movlw 	'6'
	call	send1
	movlw 	'2'
	call	send1
	movlw 	'8'
	call	send1
	movlw 	' '
	call	send1
	movlw 	'a'
	call	send1
	movlw 	'l'
	call	send1
	movlw 	'i'
	call	send1
	movlw 	'v'
	call	send1
	movlw 	'e'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message1 
	movlw 	'O'		
	call	send1
	movlw 	'k'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message2 
	movlw 	'O'		
	call	send1
	movlw 	'k'
	call	send1
	movlw 	'T'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	
message3 
	movlw 	'E'		
	call	send1
	movlw 	'x'
	call	send1
	movlw 	'i'
	call	send1
	movlw 	'T'
	call	send1
	movlw 	0x0D	; CR
	call	send1
	movlw 	0x0A	; LF 
	call	send1
	return
	end


